/**********************************************************************************************
* Device      : AD18F08
* Author      : fengxuanmian
* Version     : V0.0.1
* Date        : 2022.3.28
* Description : 配置tmr0输出buzzer(PA4)
***********************************************************************************************/

#include "AD18F08.h"

/*********************************************************************************************
* 常用配置字功能说明：
*
* _FINTOSC_DIV1     :  内部时钟分频选择
* _DBG_OFF          :  禁用DEBUG模式（使能后DEBUG口不能做普通IO用）
* _LVREN_OFF         :  LVR使能位
* _LVR24V           :  选择LVR电压为2.4V
* _FLASH_CP1_OFF    :  1K~2K*16 FLASH保护位
* _FLASH_CP0_OFF    :  0~1K*16 FLASH保护位
* _IDIS_OFF	     	:  模拟IO打开，数据读取控制位
* _CKSUM_OFF        :  使能程序校验
* _CBP_OFF			:  代码保护选择位
* _RESETE_OFF       :  禁用外部复位
* _RSEL				:  端口上下拉电阻选择
* _STV_ON		    :  堆栈溢出复位使能位
* _PSUT_2		    :  上电复位时间选择位
* _FCPU_4T          :  选择指令周期为4T模式
* _WDTE_OFF         :  看门狗使能位
* _TWDT_000         :  看门狗溢出时间选择位
* _OSCM_HIRC_16M    :  选择内部高速时钟16MHz
* _ADCSP_ON			:  ADC采集速度选择位
* 注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见头文件；
************************************************************************************************/
__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                      );

/**********************************************TIMER*****************************************/
#define           T0_CLK_EN            1    //使能TIMER0
#define           T0_CLK_DIS           0    //禁用TIMER0

#define           T0_FOSC_2            0    //TIMER0预分频为2
#define           T0_FOSC_4            1    //TIMER0预分频为4
#define           T0_FOSC_8            2    //TIMER0预分频为8
#define           T0_FOSC_16           3    //TIMER0预分频为16
#define           T0_FOSC_32           4    //TIMER0预分频为32
#define           T0_FOSC_64           5    //TIMER0预分频为64
#define           T0_FOSC_128          6    //TIMER0预分频为128
#define           T0_FOSC_256          7    //TIMER0预分频为256

#define           T0_CS_CPU            0    //TIMER0时钟源为CPU 运行时钟
#define           T0_CS_T0CK1          1    //TIMER0时钟源为T0CKI(PA5)
#define           T0_CS_2K             2    //TIMER0时钟源为内部2K
#define           T0_CS_CMPOUT         3    //TIMER0时钟源是CMPOUT输出

#define           T0_EN_NFD            1    //使能TIMER0的时钟且不分频
#define           T0_EN_FD             0    //使能TIMER0的时钟源分频

#define           T0_INT_EN            1    //使能TIMER0中断
#define           T0_INT_DIS           0    //禁止TIMER0中断

#define           T0_SE_U           0    //T0CKI脚上升沿触发计数
#define           T0_SE_D           1    //T0CKI脚下降沿触发计数

void timer0_Buzzer(unsigned char T0_CS,unsigned char CS_EN,unsigned char T0_FD);

/*
         时钟频率/计数分频/指令周期 = 计数频率    (指令周期默认配置字为4T)
                16M/2/4  =  2M
         一次计数时间:1s/2000000 = 0.5us
需要BUZZER 10Khz(中断周期20K)  需要计数 0.05ms/0.5us = 100   故T0周期取100*/

void main (void)
{
	TRISB1 = 0;
  	//时钟源选择CPU(16M)   T0使能分频   2分频
    timer0_Buzzer(T0_CS_CPU,T0_EN_FD,  T0_FOSC_2);    // BUZZER输出 输出口为PA4
	TMR0IF = 0;
	TMR0IP = 1;
	TMR0IE = 1;

	IPEN = 1;	   //使能中断优先级
	GIEH = 1;      //使能高优先级全局中断
	while(1)
	{

	}
}

//高优先级中断服务函数
void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断
	if((TMR0IE == 1)&&(TMR0IF == 1))
	{
		TMR0IF = 0;                      //清除中断标志
        TMR0 = 0;                       //手动装载初值
	}
}

//低优先级中断服务函数
void interrupt low_priority ISR_l (void)
{
//当前范例未使用
}


void timer0_Buzzer(unsigned char T0_CS,unsigned char CS_EN,unsigned char T0_FD)
{
	TRISA4 = 0;           //PA4设置输出
	T0CON = 0X80;         //启动BUZZER
	T0CON |= T0_CS << 5;  //时钟源选择
	T0CON |= CS_EN << 3;  //分频使能
	T0CON |= T0_FD;       //分频数

	PR0 = 100;            //计数周期
	TMR0 = 0;             //计数初值
	T0CLKEN = 1;          //使能T0的时钟
}
